import datetime
from datetime import datetime, timedelta, date, time

# The code in the function datetime2matlabdn is adapted from code shared on Stackoverflow:
# "http://stackoverflow.com/questions/8776414/python-datetime-to-matlab-datenum"
# The function takes a datetime type and convert it to an output equivalent to the matlab datenum function

def datetime2matlabdn(dt):
   mdn = dt + timedelta(days = 366)

   frac_seconds = (dt-datetime(dt.year,dt.month,dt.day,0,0,0)).seconds / (24.0 * 60.0 * 60.0)
   
   frac_microseconds = dt.microsecond / (24.0 * 60.0 * 60.0 * 1000000.0)
   
   return mdn.toordinal() + frac_seconds + frac_microseconds

def str2datenum(date_string, offset):
    # 20150624_152835_244
    # 0123456789012345678901234567890123
    # 0         1         2         3

    new_date_string = date_string.split("_")
    year = int(new_date_string[0][0:4])
    month = int(new_date_string[0][4:6])
    day = int(new_date_string[0][6:8])
    hour = int(new_date_string[1][0:2])
    minute = int(new_date_string[1][2:4])
    second = int(new_date_string[1][4:6])
    msec = int(new_date_string[2])

    dates = datetime(year, month, day, hour, minute, second)
    dates = datetime2matlabdn(dates)

    # no offset 
    if (offset == -1):
        seconds = dates*86400 + msec/1000.0

    # offset = first time
    elif (offset == 0):
        seconds = msec/1000.0

    # user defined offset:
    else:
        seconds = (dates-offset)*86400 + msec/1000.0

    return (dates, seconds)